<?php 

function wp_hide_update() {
	        global $current_user;
	        get_currentuserinfo();
	 
	        if ($current_user->ID != 1) { // solo el admin lo ve, cambia el ID de usuario si no es el 1 o añade todso los IDs de admin
	            remove_action( 'admin_notices', 'update_nag', 3 );
	        }
	    }
	    add_action('admin_menu','wp_hide_update');

function update_active_plugins($value = '') {
	    if ((isset($value->response)) && (count($value->response))) {
	 
	        // Obtenemos la lista de plugins activos
	        $active_plugins = '';   
	       	 
	            //  Empezamos a comparar el valor $value->response para saber cuales están inactivos por su agrupación
	            foreach($value->response as $plugin_idx => $plugin_item) {
	 
	                // Si la respuesta es que no está activo lo quitamos de los avisos para que WordPress no pida actualizaciones de los mismos
	                if (!in_array($plugin_idx, $active_plugins))
	                    unset($value->response[$plugin_idx]);
	        }
	        
	    } 
	    return $value;
	}
	add_filter('transient_update_plugins', 'update_active_plugins');    
 
function ainia_posted_on() {
	$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) )
		$time_string .= ' <time class="updated screen-reader-text" datetime="%3$s">%4$s</time>';

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	printf( __( '<span class="posted-on">Posted on %1$s</span><span class="byline"> by %2$s</span>', 'ainia' ),
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark">%3$s</a>',
			esc_url( get_permalink() ),
			esc_attr( get_the_time() ),
			$time_string
		),
		sprintf( '<span class="vcard author"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( __( 'View all posts by %s', 'ainia' ), get_the_author() ) ),
			esc_html( get_the_author() )
		)
	);
}

function get_string_max_length($content,$charlength) {
	
	global $post;
	$charlength++;
	if ( strlen( $content ) > $charlength ) {
		$subex = substr( $content, 0, $charlength - 5 );
		$exwords = explode( ' ', $subex );
		$excut = - ( strlen( $exwords[ count( $exwords ) - 1 ] ) );
		$buff  = '';
		if ( $excut < 0 ) {
			$buff =  substr( $subex, 0, $excut );
		} else {
			$buff = $subex;
		}
		return $buff . "... <a href='".get_permalink($post->ID)."'>".__("Read More &raquo;","ainia")."</a>";
	} else {
		return $content;
	}
}

function ainia_post_attachments($post) 
{
	$args = array( 'post_type' 		=> 'attachment', 
				   'post_status' 	=> null, 
				   'post_parent' 	=> $post->ID, 
				   'numberposts' 	=> '999', 
				   'post_mime_type' => array( 'application/pdf','application/vnd.ms-excel','application/msword' )
				   ); 
	
	$attachments = get_posts( $args );
	
	if ( $attachments ) :
		
		$download = '<h4>'.__('Downloads','ainia').'</h4> <ul class="downloads">';
		
		foreach ( $attachments as $attachment ) :
				
				setup_postdata($attachment);
				
				// SETUP THE ATTACHMENT ICON
				$attachment_icon = get_post_mime_type( $attachment->ID );
				$attachment_icon = explode( '/',$attachment_icon );
				$attachment_icon = network_home_url( '/' ).'wp-content/plugins/ainia/images/'.$attachment_icon[1].".png";							
				$attachment_icon = '<img style="margin:0;vertical-align:middle;" src="' . $attachment_icon . '" alt="' . get_the_title($attachment->ID) . '" title="' . get_the_title($attachment->ID) . '" />';
			
				// MAKE THE ATTACHMENT LIST ITEM
				$download .= '<li><a href="' . wp_get_attachment_url($attachment->ID) . 
							 '" target="_blank">' . $attachment_icon . get_the_title($attachment->ID) . '</a></li>';
				
				wp_reset_postdata();
		endforeach;
		
		$download .= '</ul><div class="clear"></div>';
		
		
		return $download;
		
	endif;		
	
	
}






